% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_PlotPerformanceByAttribute.R
\name{PlotPerformanceByAttribute}
\alias{PlotPerformanceByAttribute}
\alias{PlotJohan}
\title{Plot model performance by SUBID attributes}
\usage{
PlotPerformanceByAttribute(
  subass,
  subass.column = 2,
  groups = NULL,
  attributes,
  join.type = c("join", "cbind"),
  groups.color.pal = NULL,
  drop = TRUE,
  alpha = 0.4,
  trendline = TRUE,
  trendline.method = "lm",
  trendline.formula = NULL,
  trendline.alpha = 0.5,
  trendline.darken = 15,
  density.plot = FALSE,
  scale.x.log = FALSE,
  scale.y.log = FALSE,
  xlimits = c(NA, NA),
  ylimits = c(NA, NA),
  xbreaks = waiver(),
  ybreaks = waiver(),
  xlabels = waiver(),
  ylabels = waiver(),
  xlab = NULL,
  ylab = NULL,
  ncol = NULL,
  nrow = NULL,
  align = "hv",
  common.legend = TRUE,
  legend.position = "bottom",
  summary.table = FALSE,
  filename = NULL,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300
)

PlotJohan(
  subass,
  subass.column = 2,
  groups = NULL,
  attributes,
  join.type = c("join", "cbind"),
  groups.color.pal = NULL,
  drop = TRUE,
  alpha = 0.4,
  trendline = TRUE,
  trendline.method = "lm",
  trendline.formula = NULL,
  trendline.alpha = 0.5,
  trendline.darken = 15,
  density.plot = FALSE,
  scale.x.log = FALSE,
  scale.y.log = FALSE,
  xlimits = c(NA, NA),
  ylimits = c(NA, NA),
  xbreaks = waiver(),
  ybreaks = waiver(),
  xlabels = waiver(),
  ylabels = waiver(),
  xlab = NULL,
  ylab = NULL,
  ncol = NULL,
  nrow = NULL,
  align = "hv",
  common.legend = TRUE,
  legend.position = "bottom",
  summary.table = FALSE,
  filename = NULL,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300
)
}
\arguments{
\item{subass}{Information to plot, typically model performances from imported HYPE 'subassX.txt' files. Data frame object
with first column containing SUBIDs and additional columns containing model results to plot. See details.}

\item{subass.column}{Column index of information in \code{subass} to plot on the y-axis of the output plots.}

\item{groups}{Optional data frame object to specify groups of SUBIDs to plot separately. First column should contain SUBIDs and second column should contain group IDs.}

\item{attributes}{Data frame object containing the subbasin attribute information to plot on the x-axis of the output plots. Typically a data frame created by \code{\link{SubidAttributeSummary}}}

\item{join.type}{Specify how to join \code{subass} to \code{attributes}. Default "join" will perform a \code{\link{left_join}} in which the order of the SUBIDs does not need to match. Additional option "cbind"
will perform a \code{\link{cbind}} in which the order of the SUBIDs needs to match; this can be helpful if you want to create plots where \code{subass} performance data is calculated according to a
grouping variable (e.g. month).}

\item{groups.color.pal}{Vector containing colors to use when plotting groups. Only used if groups is not \code{NULL}.}

\item{drop}{Logical, should unused factor levels be omitted from the legend. See \code{\link{scale_color_manual}} and \code{link{scale_fill_manual}}.}

\item{alpha}{Numeric value to set transparency of dots in output plots. Should be in the range 0-1.}

\item{trendline}{Logical, if \code{TRUE}, then trendlines will be added to the output plots. Set to \code{FALSE} to hide trendlines. See \code{\link{geom_smooth}}.}

\item{trendline.method}{Specify method used to create trendlines. See \code{\link{geom_smooth}}.}

\item{trendline.formula}{Specify formula used to create trendlines. See \code{\link{geom_smooth}}.}

\item{trendline.alpha}{Numeric value to set transparency of trendlines in output plots. Should be in the range 0-1.}

\item{trendline.darken}{Numeric value to make the trendlines darker color shades of their corresponding scatterplot points. Should be in the range 1-100.}

\item{density.plot}{Logical, if \code{TRUE}, then density plots will be added to the output plots. Set to \code{FALSE} to hide density plots. See \code{\link{geom_density}}.}

\item{scale.x.log}{Vector describing if output plots should use a log scale on the x-axis. If length of vector == 1, then the value will be used for all output plots. Vector values should be either \code{TRUE} or \code{FALSE}. See \code{\link{scale_x_log10}}.}

\item{scale.y.log}{Vector describing if output plots should use a log scale on the y-axis. If length of vector == 1, then the value will be used for all output plots. Vector values should be either \code{TRUE} or \code{FALSE}. See \code{\link{scale_y_log10}}.}

\item{xlimits}{Vector containing minimum and maximum values for the x-axis of the output plots. See \code{\link{scale_x_continuous}}.}

\item{ylimits}{Vector containing minimum and maximum values for the y-axis of the output plots. See \code{\link{scale_y_continuous}}.}

\item{xbreaks}{Vector containing the break values used for the x-axis of the output plots. See \code{\link{scale_x_continuous}}.}

\item{ybreaks}{Vector containing the break values used for the y-axis of the output plots. See \code{\link{scale_y_continuous}}.}

\item{xlabels}{Vector containing the labels for each break value used for the x-axis of the output plots. See \code{\link{scale_x_continuous}}.}

\item{ylabels}{Vector containing the labels for each break value used for the y-axis of the output plots. See \code{\link{scale_y_continuous}}.}

\item{xlab}{String containing the text to use for the x-axis title of the output plots. See \code{\link{xlab}}.}

\item{ylab}{String containing the text to use for the y-axis title of the output plots. See \code{\link{ylab}}.}

\item{ncol}{Integer, number of columns to use in the output arranged plot. See \code{\link{ggarrange}}.}

\item{nrow}{Integer, number of rows to use in the output arranged plot. See \code{\link{ggarrange}}.}

\item{align}{Specify how output plots should be arranged. See \code{\link{ggarrange}}.}

\item{common.legend}{Specify if arranged plot should use a common legend. See \code{\link{ggarrange}}.}

\item{legend.position}{Specify position of common legend for arranged plot. See \code{\link{ggarrange}}.}

\item{summary.table}{Logical, if \code{TRUE}, then a table providing summary statistics will be included at the bottom of the output plot.}

\item{filename}{String, filename used to save plot. File extension must be specified. See \code{\link{ggsave}}.}

\item{width}{Numeric, specify width of output plot. See \code{\link{ggsave}}.}

\item{height}{Numeric, specify height of output plot. See \code{\link{ggsave}}.}

\item{units}{Specify units of \code{width} and \code{height}. See \code{\link{ggsave}}.}

\item{dpi}{Specify resolution of output plot. See \code{\link{ggsave}}.}
}
\value{
\code{PlotPerformanceByAttribute} returns a plot to the currently active plot device.
}
\description{
Create scatterplots of model performance by SUBID attributes.
}
\details{
\code{PlotPerformanceByAttribute} can be used to analyze model performance according to subbasin attributes. The function requires two primary inputs; Model performance
information is contained in the \code{subass} input, and subbasin attribute information is contained in the \code{attributes} input. The \code{subass.column} argument controls
which column of the \code{subass} data frame will be used as the y-coordinate of points. Plots will be generated for each column in the \code{attributes} data frame
(except for the column named "SUBID") using the column values as the x-coordinate of the points.

A subbasin attribute summary table can be generated using \code{\link{SubidAttributeSummary}}, and additional columns can be joined to the data frame to add additional output plots.
}
\examples{
\donttest{
subass <- ReadSubass(filename = system.file("demo_model", "results",
  "subass1.txt",
  package = "HYPEtools"
), check.names = TRUE)
gd <- ReadGeoData(filename = system.file("demo_model",
  "GeoData.txt",
  package = "HYPEtools"
))
gc <- ReadGeoClass(filename = system.file("demo_model",
  "GeoClass.txt",
  package = "HYPEtools"
))

attributes <- SubidAttributeSummary(subids <- subass$SUBID,
  gd = gd, gc = gc,
  mapoutputs = c(system.file("demo_model", "results", "mapCOUT.txt", package = "HYPEtools")),
  upstream.gd.cols = c("SLOPE_MEAN")
)

PlotPerformanceByAttribute(
  subass = subass,
  attributes = attributes[, c("SUBID", "landuse_1", "landuse_2", "landuse_3")],
  xlimits = c(0, 1)
)
}

}
\seealso{
\code{\link{ReadSubass}} for HYPE result import; \code{\link{SubidAttributeSummary}} for subbasin attribute summary
}
