% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_SumUpstreamArea.R
\name{SumUpstreamArea}
\alias{SumUpstreamArea}
\title{Calculate upstream area sums}
\usage{
SumUpstreamArea(subid = NULL, gd, bd = NULL, cl = 2, progbar = FALSE)
}
\arguments{
\item{subid}{Integer vector of SUBIDs to calculate upstream areas for (must exist in \code{gd}). If \code{NULL}, upstream areas for all
SUBIDs will be calculated.}

\item{gd}{A data frame, containing 'SUBID', 'MAINDOWN', and 'AREA' columns, e.g. an imported 'GeoData.txt' file.}

\item{bd}{A data frame, containing 'BRANCHID' and 'SOURCEID' columns, e.g. an imported 'BranchData.txt' file. Optional argument.}

\item{cl}{Integer, number of processes to use for parallel computation. Set to \code{1} for serial computation. See \code{\link[parallel:detectCores]{parallel::detectCores()}}.}

\item{progbar}{Logical, display a progress bar while calculating upstream areas. Adds overhead to calculation time but useful if you want
HYPEtools to decide how long your coffee break should take.}
}
\value{
\code{SumUpstreamArea} returns a data frame with two columns containing SUBIDs and total upstream areas (in area units as provided in \code{gd}).
Upstream areas include areas of outlet SUBIDs.
}
\description{
Function to calculate upstream areas of a vector of SUBIDs or all SUBIDs in a GeoData table.
}
\details{
\code{SumUpstreamArea} sums upstream areas of all connected upstream SUBIDs, including branch connections in case of stream bifurcations
but not including potential irrigation links or groundwater flows.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
SumUpstreamArea(subid = c(3361, 63794), gd = te, progbar = FALSE)

}
\seealso{
\code{\link{AllUpstreamSubids}}
}
