% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which2D.R
\name{which2D}
\alias{which2D}
\title{Returns the rows and columns at which a value is observed}
\usage{
which2D(x, type = "min", objective = NULL, by = "column")
}
\arguments{
\item{x}{A data.frame or a matrix}

\item{type}{Can be min, max or =, ==, >, <, >=, <=, <> or !=}

\item{objective}{If type is different from min or max, gives the value for comparison}

\item{by}{Does the search must be done by rows or by columns}
}
\value{
A matrix with the rows and columns
}
\description{
This function return the rows and columns of the maximum or minimum or a specific value is observed.
}
\details{
which2D returns the rows and columns at which a value is observed in a data.frame or a matrix
}
\examples{
library("HelpersMG")
e <- data.frame(L=c(20, 20, 10), M=c(60, 10, 20))
which2D(e)
which2D(e, by="row")
which2D(e, type="max")
which2D(e, type="=", objective=20)
which2D(e, type="<", objective=50)
which2D(e, type="=", objective=20, by="row")
}
\author{
Marc Girondot
}

