% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LD50_MHmcmc.R
\name{LD50_MHmcmc}
\alias{LD50_MHmcmc}
\title{Metropolis-Hastings algorithm for LD50}
\usage{
LD50_MHmcmc(result = stop("A result of LD50() fit must be provided"),
  n.iter = 10000, parametersMCMC = NULL, n.chains = 1, n.adapt = 0,
  thin = 1, trace = FALSE, batchSize = sqrt(n.iter),
  adaptive = FALSE, adaptive.lag = 500, adaptive.fun = function(x) { 
     ifelse(x > 0.234, 1.3, 0.7) }, intermediate = NULL,
  filename = "intermediate.Rdata", previous = NULL)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{n.iter}{Number of iterations for each step}

\item{parametersMCMC}{A set of parameters used as initial point for searching with information on priors}

\item{n.chains}{Number of replicates}

\item{n.adapt}{Number of iterations before to store outputs}

\item{thin}{Number of iterations between each stored output}

\item{trace}{True or False, shows progress}

\item{batchSize}{Number of observations to include in each batch fo SE estimation}

\item{adaptive}{Should an adaptive process for SDProp be used}

\item{adaptive.lag}{Lag to analyze the SDProp value in an adaptive content}

\item{adaptive.fun}{Function used to change the SDProp}

\item{intermediate}{Period for saving intermediate result, NULL for no save}

\item{filename}{If intermediate is not NULL, save intermediate result in this file}

\item{previous}{Previous result to be continued. Can be the filename in which intermediate results are saved.}
}
\value{
A list with resultMCMC being mcmc.list object, resultLnL being likelihoods and parametersMCMC being the parameters used
}
\description{
Run the Metropolis-Hastings algorithm for tsd.\cr
Deeply modified from a MCMC script by Olivier Martin (INRA, Paris-Grignon).\cr
The number of iterations is n.iter+n.adapt+1 because the initial likelihood is also displayed.\cr
I recommend that thin=1 because the method to estimate SE uses resampling.\cr
If initial point is maximum likelihood, n.adapt = 0 is a good solution.\cr
To get the SE from result_mcmc <- tsd_MHmcmc(result=try), use:\cr
result_mcmc$BatchSE or result_mcmc$TimeSeriesSE\cr
The batch standard error procedure is usually thought to be not as accurate as the time series methods.\cr
Based on Jones, Haran, Caffo and Neath (2005), the batch size should be equal to sqrt(n.iter).\cr
Jones, G.L., Haran, M., Caffo, B.S. and Neath, R. (2006) Fixed Width Output Analysis for Markov chain Monte Carlo , Journal of the American Statistical Association, 101:1537-1547.\cr
coda package is necessary for this function.\cr
The parameters intermediate and filename are used to save intermediate results every 'intermediate' iterations (for example 1000). Results are saved in a file of name filename.\cr
The parameter previous is used to indicate the list that has been save using the parameters intermediate and filename. It permits to continue a mcmc search.\cr
These options are used to prevent the consequences of computer crash or if the run is very very long and processes at time limited.\cr
}
\details{
LD50_MHmcmc runs the Metropolis-Hastings algorithm for LD50 (Bayesian MCMC)
}
\examples{
\dontrun{
library("HelpersMG")
data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
Alive=c(10, 12, 8, 6, 2, 1),
Dead=c(0, 1, 5, 6, 9, 15))
LD50_logistic <- LD50(data, equation="logistic")
pMCMC <- LD50_MHmcmc_p(LD50_logistic, accept=TRUE)
# Take care, it can be very long
result_mcmc_LD50 <- LD50_MHmcmc(result=LD50_logistic, 
		parametersMCMC=pMCMC, n.iter=10000, n.chains = 1,  
		n.adapt = 0, thin=1, trace=1000, adaptive=TRUE, )
# summary() permits to get rapidly the standard errors for parameters
summary(result_mcmc_LD50)
plot(x=result_mcmc_LD50, parameters="S", scale.prior=TRUE, las=1)
plot(result_mcmc_LD50, parameters="S", scale.prior=TRUE, las=1, xlim=c(-20, 20))
plot(result_mcmc_LD50, parameters="P", scale.prior=TRUE, las=1)
1-rejectionRate(as.mcmc(result_mcmc_LD50))
raftery.diag(as.mcmc(result_mcmc_LD50))
heidel.diag(as.mcmc(result_mcmc_LD50))

#### Example with Uniforms priors

pMCMC <- structure(list(Density = c("dunif", "dunif"), 
Prior1 = c(77.6216005852911, -31.0438095277258), 
Prior2 = c(310.486402341165, 31.0438095277258), 
SDProp = c(2, 0.5), 
Min = c(77.6216005852911, -31.0438095277258), 
Max = c(310.486402341165, 31.0438095277258), 
Init = c(155.243201170582, -15.5219047638629)), 
row.names = c("P", "S"), class = "data.frame")
result_mcmc_LD50 <- LD50_MHmcmc(result=LD50_logistic, 
		parametersMCMC=pMCMC, n.iter=10000, n.chains = 1,  
		n.adapt = 0, thin=1, trace=1000, adaptive=TRUE, )
# summary() permits to get rapidly the standard errors for parameters
summary(result_mcmc_LD50)
plot(x=result_mcmc_LD50, parameters="S", scale.prior=TRUE, las=1)
plot(result_mcmc_LD50, parameters="S", scale.prior=TRUE, las=1, xlim=c(-40, 40))
plot(result_mcmc_LD50, parameters="P", scale.prior=TRUE, las=1)
1-rejectionRate(as.mcmc(result_mcmc_LD50))
raftery.diag(as.mcmc(result_mcmc_LD50))
heidel.diag(as.mcmc(result_mcmc_LD50))

}
}
\seealso{
Other LD50 functions: \code{\link{LD50_MHmcmc_p}},
  \code{\link{LD50}}, \code{\link{logLik.LD50}},
  \code{\link{plot.LD50}}, \code{\link{predict.LD50}}
}
\author{
Marc Girondot
}
\concept{LD50 functions}
