% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{register}
\alias{register}
\alias{register,distributionH,distributionH-method}
\alias{register,distributionH-method}
\title{Method \code{register}}
\usage{
register(object1, object2)

\S4method{register}{distributionH,distributionH}(object1, object2)
}
\arguments{
\item{object1}{A \code{distributionH} object}

\item{object2}{A \code{distributionH} object}
}
\value{
The two \code{distributionH} objects in input sharing the same cdf (the \code{p}
slot)
}
\description{
Method \code{register}

Given two \code{distributionH} objects, it returns two equivalent distributions such that 
they share the same cdf values. This function is useful for computing basic statistics.
}
\examples{

##---- initialize two distributionH objects mydist1 and mydist2
 mydist1=distributionH(c(1,2,3),c(0, 0.4, 1))
 mydist2=distributionH(c(7,8,10,15),c(0, 0.2, 0.7, 1))
 ## register the two distributions
 regDist=register(mydist1,mydist2)
 
## OUTPUT:
## regDist$[[1]]
## An object of class "distributionH"
## Slot "x": [1] 1.0 1.5 2.0 2.5 3.0
## Slot "p": [1] 0.0 0.2 0.4 0.7 1.0
## ...
## regDist$[[2]] 
## An object of class "distributionH"
## Slot "x": [1] 7.0 8.0 8.8 10.0 15.0
## Slot "p": [1] 0.0 0.2 0.4  0.7  1.0
## ...

}
\author{
Antonio Irpino
}
\references{
Irpino, A., Lechevallier, Y. and Verde, R. (2006): \emph{Dynamic
clustering of histograms using Wasserstein metric} In: Rizzi, A., Vichi, M.
(eds.) COMPSTAT 2006. Physica-Verlag, Berlin, 869-876.\cr Irpino, A.,Verde,
R. (2006): \emph{A new Wasserstein based distance for the hierarchical
clustering of histogram symbolic data} In: Batanjeli, V., Bock, H.H.,
Ferligoj, A., Ziberna, A. (eds.) Data Science and Classification, IFCS 2006.
Springer, Berlin, 185-192.
}
\keyword{distribution}

