% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal_components.R
\name{WH.plot_multiple_indivs}
\alias{WH.plot_multiple_indivs}
\title{Plot histograms of individuals after a  Multiple factor analysis of Histogram Variables}
\usage{
WH.plot_multiple_indivs(data, res, axes = c(1, 2), indiv = 0,
  var = 1, strx = 0.1, stry = 0.1, HISTO = TRUE, coor = 0,
  stat = "mean")
}
\arguments{
\item{data}{a MatH object}

\item{res}{Results from WH.MultiplePCA.}

\item{axes}{A list of  integers, the new factorial axes c(1,2) are the default.}

\item{indiv}{A list of objects (rows) of data to plot. Default=0 all the objects of data.}

\item{var}{An integer indicating an original histogrma variable to plot.}

\item{strx}{a resizing factor for the domain of histograms (default=0.1 means 
that each distribution has a support that is one tenth of the spread of the x axis)}

\item{stry}{a resizing factor for the density of histograms (default=0.1 means 
that each distribution has a density that is one tenth of the spread of the y axis)}

\item{HISTO}{a logical value. Default=TRUE plots histograms, FALSE plot smooth densities.}

\item{coor}{(optional) if 0 (Default) takes the coordinates in res, if a a matrix is passed the coordinates are those passed}

\item{stat}{(optional) if 'mean'(Default) a plot of individuals labeled by the means is produced.
Otherwise if 'std', 'skewness' or 'kurtosis', data are labeled with this statistic.}
}
\value{
a plot of class ggplot
}
\description{
(Beta version) The function plots histogram data of the individuals for a particular
variable on a factorial palne after a Multiple factor analysis.
}
\examples{
#Do a MultiplePCA on the BLOOD dataset
\dontrun{
#' results=WH.MultiplePCA(BLOOD,list.of.vars = c(1:3)) 
#Plot histograms of variable 1 of BLOOD dataset on the first 
#factorial plane showing histograms
WH.plot_multiple_indivs(BLOOD,results,axes=c(1,2),var=1,strx=0.1,
 stry=0.1, HISTO=TRUE)
#Plot histograms of variable 1 of BLOOD dataset on the first 
#factorial plane showing densities
WH.plot_multiple_indivs(BLOOD,results,axes=c(1,2),var=1,strx=0.1,
 stry=0.1, HISTO=FALSE)
 }
}
