% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataManagement.R
\name{checkFormat}
\alias{checkFormat}
\title{Check database format}
\usage{
checkFormat(report, convertDates = FALSE, dateFormat = NULL, verbose = TRUE)
}
\arguments{
\item{report}{(list).
A list containing the base and in which will be stored reporting variables.
The base is a patient discharge database, in the form of a data.table. The data.table should have at least the following columns:
    sID: subjectID (character)
    fID: facilityID (character)
    Adate: admission date (POSIXct, but character can be converted to POSIXct)
    Ddate: discharge date (POSIXct, but character can be converted to POSIXct)}

\item{convertDates}{(boolean) TRUE/FALSE: whether the dates should converted. Default is TRUE.}

\item{dateFormat}{(boolean) The format of date as a character string (e.g. \%y\%m\%d for 20190524, or \%d-\%m-\%y for 24-05-2019).}

\item{verbose}{(boolean) print diagnostic messages. Default is FALSE.}
}
\value{
Returns either an error message, or the database (modified if need be).
}
\description{
Function that performs various generic checks to ensure that the database has the correct format
}
