% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HostSwitch.R
\name{summaryHostSwitch}
\alias{summaryHostSwitch}
\title{Summary statistics of HostSwitch simulation}
\usage{
summaryHostSwitch(HostSwitch_simulated_quantities, warmup = 1)
}
\arguments{
\item{HostSwitch_simulated_quantities}{An object created by \code{\link[=simHostSwitch]{simHostSwitch()}}}

\item{warmup}{warmup is the number of initial generations to be excluded from summary statistics, see details. Possible value are NULL or positive integer (min=1, max=50), default value = 1}
}
\value{
Summary of HostSwitch simulations
}
\description{
Summary statistics of HostSwitch simulation
}
\details{
This function generates summary statistics for HostSwitch simulations.
Quantities of interest for each simulation are averaged. If \emph{n_sim = 1}, these averages for this single simulation are shown. If \emph{n_sim > 1}, summary statistics are applied on the simulation averages.\cr\cr
\strong{Warmup} represents the initial condition for the simulation, the users may defined it as an adaptation stage of the simulation model.
If warmup = 1 the generation at time 0 is excluded from summary, if warmup = 2 the generations at times 0 and 1 are excluded and so on.
If warmup = NULL all generations are considered for summary statistics.
}
\examples{
## Create an object HostSwitch with 100 simulations and default values for all the other parameters
m1 = simHostSwitch(n_sim=100)

summaryHostSwitch(m1)
}
