% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseCoord.R
\name{ellipseCoord}
\alias{ellipseCoord}
\title{Coordinate Points Of Hotelling Ellipse}
\usage{
ellipseCoord(data, pcx = 1, pcy = 2, conf.limit = 0.95, pts = 200)
}
\arguments{
\item{data}{Data frame or tibble of PCA, PLS, and ICA scores, or from other feature projection methods.}

\item{pcx}{Integer specifying which component is on the x-axis (by default 1).}

\item{pcy}{Integer specifying which component is on the y-axis (by default 2).}

\item{conf.limit}{Number between 0 and 1 specifying the confidence level (by default 0.95).}

\item{pts}{Integer indicating the number of points for drawing the Hotelling ellipse (by default 200).}
}
\value{
Data frame containing the \emph{x} and \emph{y} coordinate points of the Hotelling ellipse.
}
\description{
Get the \emph{x} and \emph{y} coordinates of Hotelling ellipse.
}
\examples{
## Principal components analysis (PCA)
library(dplyr)
set.seed(123)
pca_mod <- specData \%>\%
  dplyr::select(where(is.numeric)) \%>\%
  FactoMineR::PCA(scale.unit = FALSE, graph = FALSE)

## Extract PCA scores
pca_scores <- pca_mod \%>\%
   purrr::pluck("ind", "coord") \%>\%
   tibble::as_tibble()

## Get Hotelling ellipse coordinate points
library(HotellingEllipse)
xy_coord <- ellipseCoord(data = pca_scores, pcx = 1, pcy = 2, conf.limit = 0.95, pts = 200)

}
\author{
Christian L. Goueguel,
christian.goueguel@gmail.com
}
