% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rewriteHydeFormula.R
\name{rewriteHydeFormula}
\alias{rewriteHydeFormula}
\title{Rewrite HydeNetwork Graph Model Formula}
\usage{
rewriteHydeFormula(old_form, new_form)
}
\arguments{
\item{old_form}{The current formula in a \code{HydeNetwork} object.}

\item{new_form}{The formula specifications to be added}
}
\description{
This is a convenience function used to assist in the updating
  of \code{HydeNetwork} network objects.  It makes it possible to add and
  subtract individual parent relationships without deleting an entire node.
  It's still a work in progress.
}
\details{
To allow changes to be made on the node-parent level, the formulae
  are broken down into a vector of component where each element identifies
  a unique parent-child relationship.  So if a node has representation
  \code{nodeA | nodeB*nodeC}, it will be broken down to
  \code{nodeA | nodeB + nodeA | nodeC}.

  After decomposing the formulae, any instances of a component in
  \code{form1} that are subtracted in \code{form2} are removed.

  Next, all added components in \code{form2} that do not already exist in
  \code{form1} are added.

  Lastly, the parents of each node are combined and the specification
  of the network is written.
}
\author{
Jarrod Dalton and Benjamin Nutter
}

