% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_LMOM.R
\name{GetEstimate_LMOM}
\alias{GetEstimate_LMOM}
\title{L-Moment estimate of a distribution}
\usage{
GetEstimate_LMOM(y, dist)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}
}
\value{
A list with the following components:
    \item{par}{numeric vector, estimated parameter vector.}
    \item{obj}{numeric, objective fonction (NA for this estimate)}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns an estimate of a distribution using the method of L-moments.
Note that for some distributions, this is not strictly speaking the L-moment estimate:
For LogNormal and LogPearsonIII, the L-moment estimate of log(data) is used.
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
GetEstimate_LMOM(y,'Normal')
GetEstimate_LMOM(y,'LogNormal')
GetEstimate_LMOM(y,'Gumbel')
GetEstimate_LMOM(y,'GEV')
GetEstimate_LMOM(y,'Poisson')
}
