% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatTable.R
\name{satTabvp}
\alias{satTabvp}
\title{Table of Saturation Volumes, Enthalpies and Entropies, Function of Pressure}
\usage{
satTabvp(p1, p2, dp)
}
\arguments{
\item{p1}{Initial Pressure [MPa]}

\item{p2}{Final Pressure [MPa]}

\item{dp}{Pressure increment [MPa]}
}
\value{
A table of saturation v, h and s, function of p
}
\description{
The function \code{satTabvp(p1, p2, dp)} returns a table of 
    threee saturation properties for two phases: Specific Volume [ m3 kg-1 ], 
    Enthalpy [kJ kg-1] and Entropy [kJ kg K-1] for a Pressure interval, p1:p2 [MPa]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p1 <- 1.0
p2 <- 10.
dp <- 0.5
satTabvp(p1, p2, dp)

p1 <- 0.1
p2 <- 10.
dp <- 0.5
Tabp <- satTabvp(p1, p2, dp)

}

