% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibrv2_index.R
\name{ibrv2_index}
\alias{ibrv2_index}
\title{IBRv2 (Integrated Biological Responses version 2)}
\usage{
ibrv2_index(df)
}
\arguments{
\item{df}{A data frame containing values the enzymes activities with a reference value on the first rows.}
}
\value{
Returns a dataframe with IBRv2 values in comparison to reference treatment
}
\description{
This function calculates de IBRv2 index proposed by Sanchez et al. 2013.
}
\details{
Returns a dataframe with the IBRv2 values for each area/treatment in your input data.

Please cite this package when you use it!
}
\section{Warnings}{


You must have at least 3 biomarkers and a maximum of 15 biomarkers to perform this index correctly.

If you have more than one independent variable, it is necessary to separate the data.frame in subsets so there's only one reference value for each level.
}

\section{References}{


Sanchez, W., Burgeot, T., & Porcher, J.-M. (2013). A novel “Integrated Biomarker Response” calculation based on reference deviation concept. Environmental Science and Pollution Research, 20(5), 2721–2725. https://doi.org/10.1007/s11356-012-1359-1
}

\examples{
data(enzact2)

ibrv2_index(enzact2)

}
