% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{AnnotateIDVCF}
\alias{AnnotateIDVCF}
\title{Add sequence context to an in-memory ID (insertion/deletion) VCF, and
  confirm that they match the given reference genome.}
\usage{
AnnotateIDVCF(ID.vcf, ref.genome, flag.mismatches = 0)
}
\arguments{
\item{ID.vcf}{An in-memory ID (insertion/deletion) VCF as a
\code{data.frame}. This function expects that there is a "context base" to
the left, for example REF = ACG, ALT = A (deletion of CG) or REF = A, ALT =
ACC (insertion of CC).}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{flag.mismatches}{If > 0, then if there are mismatches to references,
generate messages showing the mismatched rows and continue. Otherwise
\code{stop} if there are mismatched rows.}
}
\value{
A data frame with 2 new columns added to the input data frame:
\enumerate{
 \item \code{seq.context} The sequence embedding the variant.

 \item \code{seq.context.width} The width of \code{seq.context} to the left
}
}
\description{
Add sequence context to an in-memory ID (insertion/deletion) VCF, and
  confirm that they match the given reference genome.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.ID.GRCh37.vcf",
                      package = "ICAMS"))
ID.vcf <- ReadStrelkaIDVCFs(file)[[1]]
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  annotated.ID.vcf <- AnnotateIDVCF(ID.vcf, ref.genome = "hg19")}
}
