% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{CreateOneColIDMatrix}
\alias{CreateOneColIDMatrix}
\title{Create one column of the matrix for an indel catalog from *one* in-memory VCF.}
\usage{
CreateOneColIDMatrix(
  ID.vcf,
  SBS.vcf = NULL,
  sample.id = "count",
  return.annotated.vcf = FALSE
)
}
\arguments{
\item{ID.vcf}{An in-memory VCF as a data.frame annotated by the
  \code{\link{AnnotateIDVCF}} function. It must only
  contain indels and must \strong{not} contain SBSs
  (single base substitutions), DBSs, or triplet
  base substitutions, etc.

  One design decision for variant callers is the representation of "complex
  indels", e.g. mutations e.g. CAT > GC. Some callers represent this as C>G,
  A>C, and T>_. Others might represent it as CAT > CG. Multiple issues can
  arise. In PCAWG, overlapping indel/SBS calls from different callers were
  included in the indel VCFs.}

\item{SBS.vcf}{This argument defaults to \code{NULL} and
is not used. Ideally this should be an in-memory SBS VCF 
as a data frame. The rational is that for some data,
complex indels might be represented as an indel with adjoining
SBSs.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\description{
Create one column of the matrix for an indel catalog from *one* in-memory VCF.
}
\section{Value}{
 A list of a 1-column ID matrix containing the mutation catalog
  information and the annotated VCF with ID categories information added. If
  some ID variants were excluded in the analysis, an additional element
  \code{discarded.variants} will appear in the return list.
}

\keyword{internal}
