% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{GetGenomeKmerCounts}
\alias{GetGenomeKmerCounts}
\title{Generate k-mer abundance from a given genome}
\usage{
GetGenomeKmerCounts(k, ref.genome, filter.path, verbose = FALSE)
}
\arguments{
\item{k}{Length of k-mers (k>=2)}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{filter.path}{If given, homopolymers will be masked from
genome(sequence). Only simple repeat masking is accepted now.}

\item{verbose}{If \code{TRUE}, generate progress messages.}
}
\value{
Matrix of the counts of each k-mer across the \code{ref.genome}
}
\description{
Generate k-mer abundance from a given genome
}
\keyword{internal}
