% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-UserBayesFunctions.R
\name{crt.bayes.control}
\alias{crt.bayes.control}
\title{Control Parameters for Evaluating Bayesian Criteria}
\usage{
crt.bayes.control(cubature = list(tol = 1e-05, maxEval = 50000, absError
  = 0))
}
\arguments{
\item{cubature}{A list that will be passed to the arguments of the function \code{\link[cubature]{hcubature}}. See 'Details'.}
}
\value{
A list of control parameters for \code{\link[cubature]{hcubature}}.
}
\description{
The function \code{crt.bayes.control} returns a list of \code{\link[cubature]{hcubature}}  control parameters
 for  approximating the integrals in  Bayesian criteria. The key tuning parameters here
 are \strong{\code{tol}} and \strong{\code{maxEval}}. Their value affect the algorithm speed and
 the accuracy of the results.
 The user should find a trade-off between accuracy and speed for his/her example.
}
\details{
\code{cubature} is a list that its components will be passed to the function \code{\link[cubature]{hcubature}}.
Its components are:
 \describe{
  \item{\code{tol}}{The maximum tolerance. Defaults to \code{1e-5}.}
  \item{\code{maxEval}}{The maximum number of function evaluations needed. Note that the actual number of function evaluations performed is only approximately guaranteed not to exceed this number. Defaults to \code{5000}.}
  \item{\code{absError}}{The maximum absolute error tolerated. Defaults to \code{0}.}
}

One can specify a maximum number of function evaluations.
 Otherwise, the integration stops when the estimated error is less than
  the absolute error requested, or when the estimated error is less than
   tol times the integral, in absolute value, or the maximum number of iterations
    is reached, whichever is earlier.
}
\examples{
crt.bayes.control()
crt.bayes.control(cubature = list(tol = 1e-4))
}
