% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_model.R
\name{get_gen_estimates}
\alias{get_gen_estimates}
\title{Investigate Generative Model Comparisons}
\usage{
get_gen_estimates(
  training_data,
  gen_model,
  alt_gen_model = NULL,
  alt_model_type = "S",
  gene_lengths = NULL,
  calculate_deviance = FALSE
)
}
\arguments{
\item{training_data}{(list) Likely the 'train' component of a call to get_mutation_tables().}

\item{gen_model}{(list) A generative model - result of a call to fit_gen_model*().}

\item{alt_gen_model}{(list) An alternative generative model.}

\item{alt_model_type}{(character) One of "S" (saturated), "US" (sample-independent), "UG", (gene-independent), "UI" (gene/variant-interaction independent).}

\item{gene_lengths}{(dataframe) A gene lengths data frame.}

\item{calculate_deviance}{(logical) If TRUE, returns residual deviance statistics. If FALSE, returns training data predictions.}
}
\value{
If calculate_deviance = FALSE:

A list with two entries, est_mut_vec and alt_est_mut_vec, each of length n_samples x n_genes x n_mut_types, giving expected mutation value for each combination of sample, gene and variant type in the training dataset under the two models being compared.

If calculate_deviance = TRUE:

A list with two entries, deviance and df, corresponding to the residual deviance and residual degrees of freedom between the two models on the training set.
}
\description{
Given a generative model of the type we propose, and an alternate version (saturated "S", sample-independent "US", gene-independent "UG" or gene/variant interaction independent "UI"), either produces the estimated observations on the training dataset or calculates residual deviance between models.
}
\examples{
sat_dev <- get_gen_estimates(training_data = example_tables$train,
                                       gen_model = example_gen_model,
                                       alt_model_type = "S",
                                       gene_lengths = example_maf_data$gene_lengths,
                                       calculate_deviance = TRUE)
}
