% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gettree.ICcforest.R
\name{gettree.ICcforest}
\alias{gettree.ICcforest}
\title{Extract an individual tree from an ICcforest object}
\usage{
\method{gettree}{ICcforest}(object, tree = 1L, ...)
}
\arguments{
\item{object}{an object as returned by \code{\link{ICcforest}}.}

\item{tree}{an integer, the number of the tree to extract from the forest.}

\item{...}{additional arguments.}
}
\value{
An object of class \code{\link[partykit]{party}}.
}
\description{
Extract the i-th individual tree from the established ICcforest. The resulting object can be
printed or plotted, and predictions can be made using it.
}
\examples{

#### Example with dataset miceData
library(icenReg)
data(miceData)

## For ICcforest to run, Inf should be set to be a large number, for example, 9999999.
idx_inf <- (miceData$u == Inf)
miceData$u[idx_inf] <- 9999999.

## First, fit an iterval-censored conditional inference forest
Cforest <- ICcforest(formula = Surv(l,u,type="interval2")~grp, data = miceData, ntree = 50L)
## Extract the 50-th tree from the forest
plot(gettree(Cforest, tree = 50L))

}
