% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi.bootstrap}
\alias{get.pi.bootstrap}
\title{Bootstrap \code{get.pi} values.}
\usage{
get.pi.bootstrap(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  boot.iter = 500,
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to decide relationships}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range. 0 by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
pi values for all the distances we looked at
}
\description{
Runs \code{get.pi} on multiple bootstraps of the data. Is formulated
such that the relationships between
points and themselves will not be calculated.
}
\note{
In each bootstrap iteration N observations are drawn from the existing data with replacement. To avoid errors in
inference resulting from the same observatin being compared with itself in the bootstrapped data set, original indices
are perserved, and pairs of points in the bootstrapped dataset with the same original index are ignored.
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
    if(a[1]!=2) return(3)
    if (b[1]==2) return(1)
    return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2


pi<-get.pi(x,fun,r=r.max,r.low=r.min)
pi.boot<-get.pi.bootstrap(x,fun,r=r.max,r.low=r.min,boot.iter=100)

pi.ci<-apply(pi.boot[,-(1:2)],1,quantile,probs=c(0.25,0.75))

plot(r.mid, pi$pi , type="l")
lines(r.mid, pi.ci[1,] , lty=2)
lines(r.mid, pi.ci[2,] , lty=2)

}
}
\seealso{
Other get.pi: 
\code{\link{get.pi.ci}()},
\code{\link{get.pi.permute}()},
\code{\link{get.pi.typed.bootstrap}()},
\code{\link{get.pi.typed.permute}()},
\code{\link{get.pi.typed}()},
\code{\link{get.pi}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.pi}
