% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta.typed.permute}
\alias{get.theta.typed.permute}
\title{get the null distribution of the get.theta.typed function}
\usage{
get.theta.typed.permute(
  posmat,
  typeA = -1,
  typeB = -1,
  r = 1,
  r.low = rep(0, length(r)),
  permutations,
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
theta values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get theta
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\donttest{

data(DengueSimR01)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)

#Lets see if there's a difference in spatial dependence by time case occurs
type<-2-(DengueSimR01[,"time"]<75)
tmp<-cbind(DengueSimR01,type=type)

typed.theta.R01<-get.theta.typed(tmp,typeA=1,typeB=2,r=r.max,r.low=r.min)
typed.theta.type.null<-get.theta.typed.permute(tmp, typeA=1, typeB=2, 
                                               r=r.max, r.low=r.min, permutations=100)

}
}
\seealso{
Other get.theta: 
\code{\link{get.theta.bootstrap}()},
\code{\link{get.theta.ci}()},
\code{\link{get.theta.permute}()},
\code{\link{get.theta.typed.bootstrap}()},
\code{\link{get.theta.typed}()},
\code{\link{get.theta}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.theta}
