% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFeaturesValues.R
\name{get_feat_value}
\alias{get_feat_value}
\title{Feature Values Computation}
\usage{
get_feat_value(
  feat_def,
  features,
  alt_names,
  operators = c("+", "-", "*", "/", "(", ")", "ABS", "COS", "SIN", "SQR", "SQRT"),
  split = "|"
)
}
\arguments{
\item{feat_def}{a feature definition as created by \code{\link{buildFeature}}.}

\item{features}{a data.frame of features, typically an object of class `IFC_features`.}

\item{alt_names}{vector of same length as features to use for substitution. It can be used to speed up the process.}

\item{operators}{operators used. Default is c("+", "-", "*", "/", "(", ")", "ABS", "COS", "SIN", "SQR", "SQRT").}

\item{split}{string used for splitting. Default is "|".}
}
\value{
a vector of feature values.
}
\description{
Computes feature values from feature definition
}
\details{
if 'feat_def$type' is "combined" returned value will be computed according in the scope of 'features' according to 'feat_def$def'.
Otherwise, 'feat_def$name' will be searched in 'features' to return value, and if not found 'feat_def$val' will be returned.
}
\keyword{internal}
