% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGP_GPfit.R
\docType{class}
\name{IGP_GauPro}
\alias{IGP_GauPro}
\title{IGP R6 object for fitting GauPro model}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Class providing object with methods for fitting a GP model
}
\section{Methods}{

\describe{
  \item{Documentation}{For full documentation of each method go to https://github.com/CollinErickson/IGP/}
  \item{\code{new(X=NULL, Z=NULL, package=NULL,
  estimate.nugget=T, nugget0=F, ...)}}{This method
  is used to create object of this class with \code{X} and \code{Z} as the data.
  The package tells it which package to fit the GP model.}
  \item{\code{update(Xall=NULL, Zall=NULL, Xnew=NULL, Znew=NULL, ...)}}{This method
  updates the model, adding new data if given, then running optimization again.}}
}

\examples{
n <- 40
d <- 2
n2 <- 20
f1 <- function(x) {sin(2*pi*x[1]) + sin(2*pi*x[2])}
X1 <- matrix(runif(n*d),n,d)
Z1 <- apply(X1,1,f1) + rnorm(n, 0, 1e-3)
X2 <- matrix(runif(n2*d),n2,d)
Z2 <- apply(X2,1,f1)
XX1 <- matrix(runif(10),5,2)
ZZ1 <- apply(XX1, 1, f1)
u <- IGP_GauPro$new(X=X1,Z=Z1, parallel=FALSE)
cbind(u$predict(XX1), ZZ1)
u$predict.se(XX1)
u$update(Xnew=X2,Znew=Z2)
u$predict(XX1)
u$delete()
}
\section{Super class}{
\code{\link[IGP:IGP]{IGP::IGP}} -> \code{IGP_GauPro}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-.init}{\code{IGP_GauPro$.init()}}
\item \href{#method-.update}{\code{IGP_GauPro$.update()}}
\item \href{#method-.predict}{\code{IGP_GauPro$.predict()}}
\item \href{#method-.predict.se}{\code{IGP_GauPro$.predict.se()}}
\item \href{#method-.predict.var}{\code{IGP_GauPro$.predict.var()}}
\item \href{#method-.grad}{\code{IGP_GauPro$.grad()}}
\item \href{#method-.delete}{\code{IGP_GauPro$.delete()}}
\item \href{#method-.theta}{\code{IGP_GauPro$.theta()}}
\item \href{#method-.nugget}{\code{IGP_GauPro$.nugget()}}
\item \href{#method-.s2}{\code{IGP_GauPro$.s2()}}
\item \href{#method-.mean}{\code{IGP_GauPro$.mean()}}
\item \href{#method-clone}{\code{IGP_GauPro$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="at.max.var">}\href{../../IGP/html/IGP.html#method-at.max.var}{\code{IGP::IGP$at.max.var()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="delete">}\href{../../IGP/html/IGP.html#method-delete}{\code{IGP::IGP$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="finalize">}\href{../../IGP/html/IGP.html#method-finalize}{\code{IGP::IGP$finalize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad">}\href{../../IGP/html/IGP.html#method-grad}{\code{IGP::IGP$grad()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_from_theta">}\href{../../IGP/html/IGP.html#method-grad_from_theta}{\code{IGP::IGP$grad_from_theta()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_norm">}\href{../../IGP/html/IGP.html#method-grad_norm}{\code{IGP::IGP$grad_norm()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="grad_num">}\href{../../IGP/html/IGP.html#method-grad_num}{\code{IGP::IGP$grad_num()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="init">}\href{../../IGP/html/IGP.html#method-init}{\code{IGP::IGP$init()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="initialize">}\href{../../IGP/html/IGP.html#method-initialize}{\code{IGP::IGP$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="max.var">}\href{../../IGP/html/IGP.html#method-max.var}{\code{IGP::IGP$max.var()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="mean">}\href{../../IGP/html/IGP.html#method-mean}{\code{IGP::IGP$mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="nugget">}\href{../../IGP/html/IGP.html#method-nugget}{\code{IGP::IGP$nugget()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="plot">}\href{../../IGP/html/IGP.html#method-plot}{\code{IGP::IGP$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict">}\href{../../IGP/html/IGP.html#method-predict}{\code{IGP::IGP$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict.se">}\href{../../IGP/html/IGP.html#method-predict.se}{\code{IGP::IGP$predict.se()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="predict.var">}\href{../../IGP/html/IGP.html#method-predict.var}{\code{IGP::IGP$predict.var()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="prop.at.max.var">}\href{../../IGP/html/IGP.html#method-prop.at.max.var}{\code{IGP::IGP$prop.at.max.var()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="s2">}\href{../../IGP/html/IGP.html#method-s2}{\code{IGP::IGP$s2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="sample">}\href{../../IGP/html/IGP.html#method-sample}{\code{IGP::IGP$sample()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="theta">}\href{../../IGP/html/IGP.html#method-theta}{\code{IGP::IGP$theta()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="IGP" data-topic="IGP" data-id="update">}\href{../../IGP/html/IGP.html#method-update}{\code{IGP::IGP$update()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.init"></a>}}
\if{latex}{\out{\hypertarget{method-.init}{}}}
\subsection{Method \code{.init()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.init(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.update"></a>}}
\if{latex}{\out{\hypertarget{method-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.update(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.predict"></a>}}
\if{latex}{\out{\hypertarget{method-.predict}{}}}
\subsection{Method \code{.predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.predict(XX, se.fit, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.predict.se"></a>}}
\if{latex}{\out{\hypertarget{method-.predict.se}{}}}
\subsection{Method \code{.predict.se()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.predict.se(XX, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.predict.var"></a>}}
\if{latex}{\out{\hypertarget{method-.predict.var}{}}}
\subsection{Method \code{.predict.var()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.predict.var(XX, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.grad"></a>}}
\if{latex}{\out{\hypertarget{method-.grad}{}}}
\subsection{Method \code{.grad()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.grad(XX)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.delete"></a>}}
\if{latex}{\out{\hypertarget{method-.delete}{}}}
\subsection{Method \code{.delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.delete(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.theta"></a>}}
\if{latex}{\out{\hypertarget{method-.theta}{}}}
\subsection{Method \code{.theta()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.theta()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.nugget"></a>}}
\if{latex}{\out{\hypertarget{method-.nugget}{}}}
\subsection{Method \code{.nugget()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.nugget()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.s2"></a>}}
\if{latex}{\out{\hypertarget{method-.s2}{}}}
\subsection{Method \code{.s2()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.s2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.mean"></a>}}
\if{latex}{\out{\hypertarget{method-.mean}{}}}
\subsection{Method \code{.mean()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$.mean()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IGP_GauPro$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
