% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readILSA.R
\name{readILSA}
\alias{readILSA}
\title{Read ILSA data}
\usage{
readILSA(file, mistoNAs = FALSE, untibble = FALSE)
}
\arguments{
\item{file}{a path to an '.rds', '.sav', or '.zsav' file.}

\item{mistoNAs}{a logical value indicating if missing values should be 
converted into NAs. Default is \code{FALSE}.}

\item{untibble}{a logical value indicating if data should be converted into
a plain data frame with no column attributes.}
}
\value{
A tibble or a data frame.
}
\description{
Reads files created with ILSAmerge().
}
\examples{
# Path where raw 'SPSS' files are
input <- system.file("extdata/reds", package = "ILSAmerge")

# Path where merged files will be saved
unlink(file.path(tempdir(),"ILSAmerge"),recursive = TRUE)
dir.create(file.path(tempdir(),"ILSAmerge"))
output <- file.path(tempdir(),"ILSAmerge")

# Merging 'REDS' 2021, as .rds file
ILSAmerge(inputdir = input, outputdir = output, filetype = "rds", quiet = FALSE)

# Read student file
readILSA(file = file.path(output,"BSGV1.rds"))

}
