% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCA.NormIC.R
\name{INCA.NormIC}
\alias{INCA.NormIC}
\title{INCATome Normalisation by Internal Control Probes}
\usage{
INCA.NormIC(x, InternalFile, wcol, base = 2, mva = TRUE)
}
\arguments{
\item{x}{an RGList object}

\item{InternalFile}{a data.frame specifying the names of the array files (in a column called "FileName") and the expected log2 ratios for two internal control genes selected by the user (respectively in columns headed with the gene names). Expected log2 ratios are to be acquired experimentally, for each corresponding sample (typically by northern blotting or qPCR).}

\item{wcol}{an integer specifying the number of the column where Gene Names can be found in the gene annotation table.}

\item{base}{an integer specifying the log base. Default is 2.}

\item{mva}{logical, TRUE to plot MA plots before and after normalisation for each array.}
}
\value{
A new RGList object containing the normalised array data. Additionally, if mva is TRUE, MA plots before and after normalisations will be generated for each arrays.
}
\description{
Performs the INCATome normalisation using invariance of Internal Control probes selected by the user for microarray data.
}
\examples{
#Load the INCATome Dataset
data(INCATomeData)
attach(INCATomeData)
dc=INCA.NormIC(RGdataBG,idata,8)
}
