% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{all_results_ex}
\alias{all_results_ex}
\title{Output tibble after applying all IND~pressure modeling functions}
\format{A data frame with 84 rows and 31 variables:
\describe{
  \item{\code{id}}{Numerical IDs for the IND~press combinations.}
  \item{\code{ind}}{Indicator names.}
  \item{\code{press}}{Pressure names.}
  \item{\code{model_type}}{Specification of the model type; at this stage containing only
             "gam" (Generalized Additive Model).}
  \item{\code{corrstruc}}{Specification of the correlation structure; at this stage
             containing only "none".}
  \item{\code{aic}}{AIC of the fitted models}
  \item{\code{edf}}{Estimated degrees of freedom for the model terms.}
  \item{\code{p_val}}{The p values for the smoothing term (the pressure).}
  \item{\code{signif_code}}{The significance codes for the p-values.}
  \item{\code{r_sq}}{The adjusted r-squared for the models. Defined as the proportion
              of variance explained, where original variance and residual variance are
              both estimated using unbiased estimators. This quantity can be negative
              if your model is worse than a one parameter constant model, and can be
              higher for the smaller of two nested models.}
  \item{\code{expl_dev}}{The proportion of the null deviance explained by the models.}
  \item{\code{nrmse}}{Absolute values of the Normalized Root Mean Square Error (NRMSE).}
  \item{\code{ks_test}}{The p-values from a Kolmogorov-Smirnov Test applied on the model
              residuals to test for normal distribution. P-values > 0.05 indicate
              normally distributed residuals.}
  \item{\code{tac}}{logical; indicates whether temporal autocorrelation (TAC) was detected
              in the residuals. TRUE if model residuals show TAC.}
  \item{\code{pres_outlier}}{A list-column with outliers identified for each model (i.e.
              Cook`s distance > 1). The indices present the position in
              the training data, including NAs.}
  \item{\code{excl_outlier}}{A list-column listing all outliers per model that have been
              excluded in the GAM fitting}
  \item{\code{model}}{A list-column of IND~press-specific gam objects.}
  \item{\code{prop}}{The proportion of the observed pressure range where the IND
             indicator shows a response (see the last section in \emph{Details})}
  \item{\code{zero_in_conf}}{A list-column of logical vectors indicating for
             every pressure value (in press_seq) whether the slope of the IND
             response at that pressure value is within the confidence interval,
             i.e. is zero.}
  \item{\code{zic_start_end}}{A list-column of logical vectors indicating for
             every pressure value (in press_seq) whether the slope is considered
             as zero for the proportion calculation (see see the last section in
             \emph{Details})}.
  \item{\code{press_seq}}{A list-column with sequences of evenly spaced pressure
             values (with the length of the time series).}
  \item{\code{pred}}{A list-column with the predicted indicator responses
             averaged across all bootstraps.}
  \item{\code{pred_ci_up}}{A list-column with the upper confidence limit of the
             bootstrapped predictions.}
  \item{\code{pred_ci_low}}{A list-column with the lower confidence limit of the
             bootstrapped predictions.}
  \item{\code{deriv1}}{A list-column with the first derivatives of the indicator responses
             averaged across all bootstraps.}
  \item{\code{deriv1_ci_up}}{A list-column with the upper confidence limit of the
             bootstrapped first derivatives.}
  \item{\code{deriv1_ci_low}}{A list-column with the lower confidence limit of the
             bootstrapped first derivatives.}
  \item{\code{adj_n_boot}}{The number of successful bootstrap samples that was
             actually used for calculating the mean and confidence intervals of
             the predicted indicator response and the derivative.}
  \item{\code{boot_error}}{A list-column capturing potential error messages that
             occurred as side effects when refitting the GAM(M)s on each bootstrap
             sample.}
  \item{\code{interaction}}{logical; if TRUE, at least one thresh_gam
             performs better than its corresponding gam based on the leave-one-out
             cross-validation.}
  \item{\code{thresh_var}}{A list-column with the threshold variables of the
             better performing thresh_models.}
  \item{\code{thresh_models}}{A list-column with nested lists containing the
             better performing thresh_models.}
  \item{\code{thresh_error}}{A list-column capturing potential error messages that
             occurred as side effects when fitting each threshold GAMs and performing the
             LOOCV.}
  \item{\code{tac_in_thresh}}{logical vector; indicates for every listed
             thresh_model whether temporal autocorrelation (TAC) was
             detected in the residuals. TRUE if model residuals show TAC.}
}}
\usage{
all_results_ex
}
\description{
This is an example output tibble based on the Central Baltic Sea
food web indicator demonstration data after applying the \code{\link{calc_deriv}}
and the \code{\link{test_interaction}} functions on the
\code{merge_models_ex} tibble.
}
\keyword{datasets}
