% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_sc.R
\name{dist_sc}
\alias{dist_sc}
\title{Score-based distance matrix}
\usage{
dist_sc(scores_tbl, method_dist = "euclidean", ...)
}
\arguments{
\item{scores_tbl}{The output tibble from the scoring.}

\item{method_dist}{Dissimilarity index used in the \code{vegdist} function to
to calculate the dissimilarity matrix based on the scores.
Default is `euclidean`, for alternatives see \code{\link[vegan]{vegdist}}.}

\item{...}{Further arguments to be passed to the method \code{vegdist}.}
}
\value{
The function returns a \code{\link[stats]{dist}} object.
}
\description{
The function computes a distance matrix based on the \code{\link{scoring}} output
tibble (or the output tibble from the \code{\link{expect_resp}} function).
}
\examples{
# Using the Baltic Sea demo data
scores_tbl <- scoring(trend_tbl = model_trend_ex,
  mod_tbl = all_results_ex, press_type = press_type_ex)
dist_matrix <- dist_sc(scores_tbl, method_dist = "euclidean")
}
\seealso{
\code{\link[vegan]{vegdist}} for the computation of the
dissimilarity index

Other score-based IND performance functions: \code{\link{clust_sc}},
  \code{\link{expect_resp}}, \code{\link{plot_clust_sc}},
  \code{\link{plot_spiechart}}, \code{\link{scoring}},
  \code{\link{summary_sc}}
}
