% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_id.R
\name{find_id}
\alias{find_id}
\title{Extracts the IND~pressure IDs in the tibble.}
\usage{
find_id(mod_tbl, ind_name = NULL, press_name = NULL)
}
\arguments{
\item{mod_tbl}{A tibble containing the columns \code{ind} and \code{press.}.}

\item{ind_name}{One or more character string naming the indicators of interest.}

\item{press_name}{One or more character string naming the pressures of interest.}
}
\value{
The function returns a tibble including the id for the respective `ind`
and/or `press`.
}
\description{
\code{find_id} is a helper function for the user to extract the ID for a
specific indicator(IND), pressure or IND~pressure combination. The `id` in
the returned tibble can then be used for filtering tibbles when using the
other IND~pressure modeling functions.
}
\examples{
# Using the Baltic Sea demo data:
# Look for specific INDs in combination with every pressure
ind_name <- c("TZA","MS")
find_id(model_gam_ex, ind_name)$id
# Look for specific IND~pressure combinations
press_name <- c("Tsum", "Swin")
find_id(model_gam_ex, ind_name, press_name)
# Look for specific pressures in combination with every IND
find_id(model_gam_ex, press_name = press_name)
}
\seealso{
Other IND~pressure modeling functions: \code{\link{ind_init}},
  \code{\link{model_gamm}}, \code{\link{model_gam}},
  \code{\link{plot_diagnostics}}, \code{\link{plot_model}},
  \code{\link{scoring}}, \code{\link{select_model}},
  \code{\link{test_interaction}}
}
\concept{IND~pressure modeling functions}
