% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_sspde.R
\name{cgeneric_sspde}
\alias{cgeneric_sspde}
\title{Define the stationary SPDE cgeneric model for INLA.}
\usage{
cgeneric_sspde(
  mesh,
  alpha,
  control.priors,
  constr = FALSE,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{mesh}{triangulation mesh to discretize the model.}

\item{alpha}{integer used to compute the smoothness parameter.}

\item{control.priors}{named list with parameter priors.
This shall contain prior.range and prior.sigma as length two
vectors with (U, a) to define the PC-prior parameters such that
P(range<U)=a and P(sigma>U)=a, respectively.
See Fuglstad et. al. (2019) <DOI: 10.1080/01621459.2017.1415907>.
If a=0 then U is taken to be the fixed value of the parameter.}

\item{constr}{logical to indicate if the integral of the field
over the domain is to be constrained to zero. Default value is FALSE.}

\item{debug}{integer indicating the debug level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical indicating if is to be used
shared object pre-compiled by INLA. Not considered if
libpath is provided.}

\item{libpath}{string to the shared object. Default is NULL.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define the stationary SPDE cgeneric model for INLA.
}
\note{
This is the stationary case of \code{\link[INLA:inla.spde2.pcmatern]{INLA::inla.spde2.pcmatern()}}
with slight change on the marginal variance when the domain is
the sphere, following Eq. (23) in Lindgren et. al. (2024).
}
\references{
Geir-Arne Fuglstad, Daniel Simpson, Finn Lindgren & Håvard Rue (2019).
Constructing Priors that Penalize the Complexity of Gaussian Random Fields.
Journal of the American Statistical Association, V. 114, Issue 525.

Finn Lindgren, Haakon Bakka, David Bolin, Elias Krainski and Håvard Rue (2024).
A diffusion-based spatio-temporal extension of Gaussian Matérn fields.
\href{https://www.idescat.cat/sort/sort481/48.1.1.Lindgren-etal.pdf}{SORT 48 (1), 3-66}
<doi: 10.57645/20.8080.02.13>
}
