% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_inla_residuals.R
\name{plot_inla_residuals}
\alias{plot_inla_residuals}
\title{Plot residuals of observed vs predicted values for INLA model}
\usage{
plot_inla_residuals(inla.model, observed)
}
\arguments{
\item{inla.model}{An inla object}

\item{observed}{The observed values}
}
\description{
Plot residuals of observed vs predicted values for INLA model
}
\examples{
 library(INLA)
 data(Epil)
 observed <- Epil[1:30, 'y']
 Epil <- rbind(Epil, Epil[1:30, ])
 Epil[1:30, 'y'] <- NA
 ## make centered covariates
 formula = y ~ Trt + Age + V4 +
          f(Ind, model="iid") + f(rand,model="iid")
 result = inla(formula, family="poisson", data = Epil, 
               control.predictor = list(compute = TRUE, link = 1))
 plot_inla_residuals(result, observed)
 

 data(Seeds)
 l <- nrow(Seeds)
 Seeds <- rbind(Seeds, Seeds)
 Seeds$r[1:l] <- NA


 formula = r ~ x1 * x2 + f(plate, model = "iid")
 mod.seeds = inla(formula, data=Seeds, family = "binomial", Ntrials = n, 
                  control.predictor = list(compute = TRUE, link = 1))
 plot_inla_residuals(mod.seeds, na.omit(Seeds$r / Seeds$n))
}
