% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat.R
\name{flat}
\alias{flat}
\title{Flat sequences}
\usage{
flat(y, maxseq, exclude = NULL)
}
\arguments{
\item{y}{data vector}

\item{maxseq}{the maximum number of contiguous repetitions of a value (e.g., if 3, sequences of 4 will be flagged)}

\item{exclude}{values to be excluded. This is useful for variables where a single value is expected to repeat many times, e.g. 0.0 in precipitation.}
}
\value{
list of positions which do not pass this QC test. If all positions pass the test, returns NULL
}
\description{
This function detects consecutive equal values (e.g., 15.1, 15.1, 15.1, 15.1...). Also can be used to detect consecutive equal decimal part of the values (e.g., 15.1, 12.1, 13.1, 10.1 ...)
}
\examples{
y<-rnorm(100)
y[10:20]<-10
flat(y,5)

#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
y<-readecad(input=path2inptfl,missing= -9999)[,4]
#Find all consecutive (with a length > 5 elements) equal values in the time series
flat(y,5)

#Introduce the duplicated dates
y[6:12]<-10
#Find all consecutive (with a length > 5 elements) equal values in the time series
flat(y,5)
}
