% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readecad.R
\name{readecad}
\alias{readecad}
\title{Reads an ECA&D data/sources/stations file}
\usage{
readecad(input = "SS_STAID000143.txt", missing = -9999)
}
\arguments{
\item{input}{ECA&D filename}

\item{missing}{missing value code, set to the default ECA&D mvc}
}
\value{
data frame containing data (time series) from the ECA&D file. An introductory part of the ECA&D file with meta data information is skipped
}
\description{
This function reads one ECA&D file and puts it in yyyy/mm/dd/value. Data is NOT divided by 10, to transform it into true units
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "CC_SOUID132727.txt", package = "INQC")
#Read the data file
df<-readecad(input=path2inptfl,missing= -9999) 
}
