% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustering}
\alias{clustering}
\title{(Internal function) Perform the clustering process of IPCAPS}
\usage{
clustering(
  dataframe,
  node = 1,
  result.dir,
  threshold,
  min.fst,
  method = "mix",
  min.in.group = 20,
  datatype = "snp",
  nonlinear = FALSE
)
}
\arguments{
\item{dataframe}{A data frame containing \code{raw.data} (matrix or data
frame), \code{label} (vector), and \code{index} (vector). \code{raw.data}
represents a matrix of subset of input data. \code{label} represents a vector
of labels for all rows of \code{raw.data}. \code{index} represents a vector
of indexes that are selected from the original input data.}

\item{node}{An integer representing the current node number which is being
analyzed.}

\item{result.dir}{An output directory}

\item{threshold}{A threshold or a cutoff to stop the IPCAPS process. Also see
\code{\link{ipcaps}} (the parameter \code{threshold}).}

\item{min.fst}{A number represents a cutoff for mininum Fst value.}

\item{method}{A clustering method selected from the \code{\link{ipcaps}}
function. See \code{\link{ipcaps}} for available methods.}

\item{min.in.group}{A integer represents a minimum number of group members.}

\item{datatype}{To specify whether the input data are 'snp' or other type.
Defalut = 'snp'.}

\item{nonlinear}{(Unimplemented) To specify whether linear or non-linear
method is used for IPCAPS analysis. If TRUE, non-linear method is used,
otherwise linear method is used. Default = FALSE.}
}
\value{
A list containing \code{status}, \code{node}, and \code{new.index}
as explained below:
\itemize{
\item \code{$status} is either \code{0} representing that the criterion is
not met, or \code{1} representing that the criterion is met.
\item \code{$node} is an integer representing the current node number which
is being analyzed.
\item \code{$new.index} is a list of vectors containing a subset of indexes
split from \code{dataframe$index} according to a clustering result.
}
}
\description{
(Internal function) Perform the clustering process of IPCAPS
}
