% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBLUP.fit.R
\name{GBLUP.fit}
\alias{GBLUP.fit}
\title{Muti-trait GBLUP Model}
\usage{
GBLUP.fit(t1, t2, t3, t4, t5, geno = NULL, K = NULL, outcross = FALSE)
}
\arguments{
\item{t1}{vector. The phenotype of trait1. The missing value must be coded as NA.
The length of all triat must be the same.}

\item{t2}{vector. The phenotype of trait2. The missing value must be coded as NA.
The length of all triat must be the same.}

\item{t3}{vector. The phenotype of trait3. The missing value must be coded as NA.
The length of all triat must be the same.}

\item{t4}{vector. The phenotype of trait4. The missing value must be coded as NA.
The length of all triat must be the same.}

\item{t5}{vector. The phenotype of trait5. The missing value must be coded as NA.
The length of all triat must be the same.}

\item{geno}{matrix. An n*p matrix with n individuals and p markers of the
training population. The markers must be coded as 1, 0, or -1 for alleles AA,
Aa, or aa. The missing value must have been already imputed.}

\item{K}{matrix. An n*n matrix denotes the genomic relationship matrix of the
training population if geno is set to be NULL.}

\item{outcross}{logical. A logical variable, if outcross is set to be TRUE,
the crop is regarded as an outcross crop. The kinship matrix of dominance
effects are also considered in the model. The geno data must be given when
outcross being TRUE.}
}
\value{
\item{fitted.value}{The fitted values.}
\item{fitted.A}{The additive effect part of fitted values.}
\item{fitted.D}{The dominance effect part of fitted values.}
\item{mu}{The average value of fitted values.}
}
\description{
Built the muti-trait GBLUP model using the phenotypic and genotypic data of a
training population by 'mmer' from R package 'sommer'. Then, output the fitted
values of the training population.
}
\note{
Due to restrictions on the use of the funtion 'mmer', if an unknown error occurs
during use, please try to input the phenotype data as the format shown in the
example.
}
\examples{
# generate simulated data
t1 <- rnorm(50,30,10)
t2 <- rnorm(50,10,5)
t3 <- rnorm(50,20,20)
t4 <- NULL
t5 <- NULL

# run with the marker score matrix
geno.test <- matrix(sample(c(1, -1), 5000, replace = TRUE), 50, 100)
result1 <- GBLUP.fit(t1, t2, t3, t4, t5, geno = geno.test)
result1$fitted.value

# run with the genomic relationship matrix
K.test <- geno.test\%*\%t(geno.test)/ncol(geno.test)
result2 <- GBLUP.fit(t1, t2, t3, t4, t5, K = K.test)
result2$fitted.value
}
\references{
Habier D, Fernando RL, Dekkers JCM. 2007. The impact of genetic relationship
information on genome-assisted breeding values. Genetics 177:2389-2397.

VanRaden PM. 2008. Efficient methods to compute genomic predictions.
J Dairy Sci. 91:4414-4423.
}
\seealso{
\code{\link[sommer]{mmer}}
}
