% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{biserial.cor}
\alias{biserial.cor}
\title{Biserial Correlation}
\usage{
biserial.cor(x, y, use = c("all.obs", "complete.obs"), level = 1)
}
\arguments{
\item{x}{a numeric vector representing the continuous variable.}

\item{y}{a numeric vector representing the dichotomous variable.}

\item{use}{Is a option for the use of missing values.}

\item{level}{which level of y to use.}
}
\value{
The value of the point-biserial correlation.
}
\description{
Point-Biserial correlation coefficient is a correlation coefficient
used when one variable is continuous and the other variable is dichotomous.
}
\details{
It is calculated by applying the Pearson correlation coefficient to the case
where one of the variables has dichotomous nature. 
It is calculated as \deqn{r_{xy} = (\bar{x}_p - \bar{x}_q / S_x)*\sqrt{pq}}
where p  is the proportion of subjects with one of the two possible values of the 
variable Y, q is the proportion of subjects with the other possible value, 
\deqn{\bar{x}_p} and \deqn{\bar{x}_q} is the average X subjects whose proportion is p and q respectively,
and $S_x$ is the standard deviation of all subjects X.
This function was adapted from ltm_1.0 package.
}
\examples{
data <- simulateTest(model="2PL",items=10,individuals=1000)
biserial.cor(rowSums(data$test), data$test[,1])
}
\references{
U.Olsson, F.Drasgow, and N.Dorans (1982). The polyserial correlation coefficient. Psychometrika, 47:337-347.

Cox. N.R. (1974). Estimation of the Correlation between a Continuous and a Discrete Variable. Biometrics, 30:171-178.
}

