% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{alpha.cronbach}
\alias{alpha.cronbach}
\title{Cronbach's alpha}
\usage{
alpha.cronbach(test)
}
\arguments{
\item{test}{a matrix or a Dataframe that holds the test response data}
}
\value{
Cronbach's alpha for the test and the number of individuals of test.
}
\description{
Cronbach's alpha measures how correlated are the items in a test
}
\details{
the coefficient is calculated \deqn{\alpha = (n/n-1)*(1 - (\sum V_i/V_t))}
where $V_t$ is the variance of test scores and $V_i$ is the variance of item scores.
It is desirable that the items are closely interrelated (coefficient near 1).
This function was extracted from multilevel_2.5 package.
}
\examples{
data <- simulateTest(model="2PL",items=10,individuals=1000)
alpha.cronbach(data$test)
}
\references{
Cronbach L. J. (1951) Coefficient Alpha and the internal structure of tests. Psychometrika, 16,297-334
}

