% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfit.R
\name{plotevenlope}
\alias{plotenvelope}
\alias{plotevenlope}
\title{Confidence bands}
\usage{
plotenvelope(item, numboot, alpha, model, data)
}
\arguments{
\item{item}{a number indicating the item that you want evaluate.}

\item{numboot}{number of iterations bootstrap, used to plot the envelopes.}

\item{alpha}{level of significance to plot the envelopes.}

\item{model}{object irtpp() type.}

\item{data}{the data frame or a matrix with the test data.}
}
\value{
plot with the envelopes and the caracteristic curve of the item.
}
\description{
Graphic bands of confidence of an item, to evaluate 
the goodness of fit of the model.
}
\examples{

#Simulates a test and returns a list:
test <- simulateTest()

#the simulated data:
t_data <- test$test

#model:
mod <- irtpp(dataset = t_data,model = "3PL")

#Envelopes:
item <- 8
numboot <- 100
alpha <- 0.05

#call the function:
plotenvelope(item=item,numboot=numboot,alpha=alpha,model=mod,data=t_data)
}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
David Thissen, Howard Wainer  D. (1990). Confidence Envelopes for Item Response Theory. \emph{Journal of Educational Statistics, Vol 15, No 2}, 113-128.
}
\seealso{
\code{\link{orlando_itemf}}, \code{\link{z3_itemf}}
}

