% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R
\name{phi}
\alias{phi}
\title{Obtain the relevance of data points}
\usage{
phi(y, phi.parms = NULL)
}
\arguments{
\item{y}{The target variable of a given data set}

\item{phi.parms}{The relevance function providing the data points where the pairs of values-relevance are known}
}
\value{
A vector with the relevance values of a given target variable
}
\description{
The phi function retrieves the relevance value of the values in a target variable. It does so by resorting to the Piecewise Cubic Hermite Interpolation Polynomial method for interpolating over a set of maximum and minimum relevance points. The notion of relevance is associated with rarity.Nonetheless, this notion may depend on the domain experts knowledge
}
\examples{
library(IRon)
data(accel)

ind <- sample(1:nrow(accel),0.75*nrow(accel))

train <- accel[ind,]
test <- accel[-ind,]

ph <- phi.control(train$acceleration)
phis <- phi(test$acceleration,phi.parms=ph)

plot(test$acceleration,phis,xlab="Y",ylab="Relevance")
}
