% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swp.R
\name{RSWP}
\alias{RSWP}
\title{Reverse Sweep Function}
\usage{
RSWP(V, b)
}
\arguments{
\item{V}{A symmetric matrix to be reverse swept; this matrix cannot contain missing 
data or infinite values.}

\item{b}{An array of integers or column names to reverse sweep.}
}
\value{
The reverse swept matrix \code{V}.  Reverse sweeping will not occur if the 
  column being swept has a zero-valued diagonal element.
}
\description{
\code{RSWP} performs the reverse sweep operator.
}
\details{
This program applies the reverse sweep operator as defined in 
  (Dempster 1969).
}
\examples{
set.seed(100)
# generate symmetric positive definite matrix
Sigma <- rWishart(1,4,diag(3))[,,1]
# sweep all the columns to produce the inverse
# and then reverse sweep them all back to Sigma
Sigma2 <- RSWP(SWP(Sigma,1:3),1:3)
}
\references{
Dempster, A.P. (1969). \emph{Elements of continuous multivariate analysis}. Reading, MA: Addison-Wesley.
}

