% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biasCorrect.R
\name{makePolygons}
\alias{makePolygons}
\title{Create polygon from mapped points}
\usage{
makePolygons(myEnd, myFixedLine, myOut, myLand = land,
  polyName = "unspecified")
}
\arguments{
\item{myEnd}{n x 2  list of mapped points, i.e. the points to which the polygon should extend}

\item{myFixedLine}{\code{SpatialLines} object from which the mapping vectors emanate}

\item{myOut}{\code{SpatialPolygons} object outside the current region that borders the region's fixed line. It is
used to determine if points are being mapped outside the region of interest.}

\item{myLand}{\code{SpatialPolygons} object for the land}

\item{polyName}{character string to name the new polygon (defaults to "unspecified")}
}
\value{
\code{SpatialPolygons} object created from the mapped points
}
\description{
Create a new polygon from the coordinates of mapped points
}
\examples{
newPoly <- makePolygons(myEnd = mappedPoints, myFixedLine = regionInfo$lines[[1]],
                        myOut = regionInfo$out[[1]])
plot(newPoly)
}
