% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{sipSep2006_2007}
\alias{sipSep2006_2007}
\title{Ensemble sea ice probability for September 2006-2007 (lead time 2.5 months)}
\format{array of dimension of 2 x 304 x 448 (corresponding to year x
        longitude x latitude)}
\usage{
sipSep2006_2007
}
\description{
The object \code{sipSep2006_2007} is an array of the proportion of ensemble
members that have sea ice concentrations of at least 15\%. The predictions are
are from the European Center for Medium-Range Weather Forecasts (ECMWF)
ensemble and converted to a Polar stereographic grid.
}
\examples{
data(sipSep2006_2007)
dim(sipSep2006_2007)
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center.
            doi: \url{https://doi.org/10.5067/7Q8HCCWS4I0R}

            Copernicus Climate Change Service (2019). Description of the c3s
            seasonal multi-system. \url{https://confluence.ecmwf.int/display/COPSRV/Description+of+the+C3S+seasonal+multi-system}

            Sea Ice Prediction Network (2019). Sea ice prediction network
            predictability portal. \url{https://atmos.uw.edu/sipn/.}
}
\keyword{datasets}
