% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffectivenessOfSolution.R
\name{EffectivenessOfSolution}
\alias{EffectivenessOfSolution}
\title{Function to estimate the effectiveness of solution sources (S.S.) by loss source (Percentage_I.I. > 0.00) in the production system.}
\usage{
EffectivenessOfSolution(DataLossSource,DataSolutionSource,Production, verbose=TRUE)
}
\arguments{
\item{DataLossSource}{It is an matrix object containing data from loss sources.}

\item{DataSolutionSource}{It is an matrix object containing data from solution sources.}

\item{Production}{It is a vector containing the production data.}

\item{verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the effectiveness of solution}
}
\value{
The function returns several indices associated with the source of loss.
}
\description{
This function allows to calculate E.S. of each S.S. by L.S. (significant in the reduction of production) in
the productive system. Equation: E.S. = R2 x (1 - P) when it is of the first degree, or E.S. = ((R2 x (1 - P))x(B2/B1) when
it is of the second degree. Where, R2 = determination coefficient and P = significance of ANOVA, B1 = regression coefficient,
and B2 = regression coefficient (variable2), of the simple regression equation of the S.S..
}
\examples{
library(ImportanceIndice)
data("DataLossSource")
data("DataSolutionSource")
data("DataProduction")
data("DataNumberSamples")

Distribution_LossSource(DataLossSource)
Distribution_SolutionSource(DataSolutionSource)

#################################################
###################################################


LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
LS

LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
                  Evaluation=DataNumberSamples,
                  SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
LP

ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
                           DataSolutionSource=DataSolutionSource,Production=DataProduction)
ES

}
\seealso{
\code{\link{LossProduction}} ,  \code{\link{NonAttentionLevel}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
