/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfloat;

import cern.jet.math.tfloat.FloatConstants;

public class FloatArithmetic
extends FloatConstants {
    private static final float[] stirlingCorrection = new float[]{0.0f, 0.08106147f, 0.041340698f, 0.027677925f, 0.020790672f, 0.01664469f, 0.013876129f, 0.01189671f, 0.010411265f, 0.009255462f, 0.008330563f, 0.0075736754f, 0.0069428403f, 0.006408994f, 0.00595137f, 0.005554734f, 0.005207656f, 0.004901396f, 0.0046291538f, 0.0043855603f, 0.0041663195f, 0.0039679543f, 0.0037876181f, 0.0036229603f, 0.0034720213f, 0.0033331555f, 0.0032049702f, 0.0030862787f, 0.002976064f, 0.0028734494f, 0.002777675f};
    protected static final float[] logFactorials = new float[]{0.0f, 0.0f, 0.6931472f, 1.7917595f, 3.1780539f, 4.787492f, 6.5792513f, 8.525162f, 10.604603f, 12.801827f, 15.104413f, 17.502308f, 19.987215f, 22.552164f, 25.191221f, 27.899271f, 30.67186f, 33.505074f, 36.395447f, 39.339886f, 42.335617f, 45.38014f, 48.47118f, 51.606674f, 54.78473f, 58.003605f, 61.261703f, 64.55754f, 67.88974f, 71.25704f};
    protected static final long[] longFactorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    protected static final float[] floatFactorials = new float[]{5.109094E19f, 1.1240007E21f, 2.5852017E22f, 6.204484E23f, 1.551121E25f, 4.0329146E26f, 1.0888869E28f, 3.0488833E29f, 8.841762E30f, 2.6525285E32f, 8.2228384E33f, 2.6313083E35f, 8.683318E36f, 2.952328E38f};

    protected FloatArithmetic() {
    }

    public static float binomial(float f, long l) {
        if (l < 0L) {
            return 0.0f;
        }
        if (l == 0L) {
            return 1.0f;
        }
        if (l == 1L) {
            return f;
        }
        float f2 = f - (float)l + 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        long l2 = l;
        while (l2-- > 0L) {
            float f5 = f2;
            f2 = f5 + 1.0f;
            float f6 = f3;
            f3 = f6 + 1.0f;
            f4 *= f5 / f6;
        }
        return f4;
    }

    public static float binomial(long l, long l2) {
        float f;
        if (l2 < 0L) {
            return 0.0f;
        }
        if (l2 == 0L || l2 == l) {
            return 1.0f;
        }
        if (l2 == 1L || l2 == l - 1L) {
            return l;
        }
        if (l > l2) {
            int n = longFactorials.length + floatFactorials.length;
            if (l < (long)n) {
                float f2 = FloatArithmetic.factorial((int)l);
                float f3 = FloatArithmetic.factorial((int)l2);
                float f4 = FloatArithmetic.factorial((int)(l - l2));
                f = f4 * f3;
                if (f != Float.POSITIVE_INFINITY) {
                    return f2 / f;
                }
            }
            if (l2 > l / 2L) {
                l2 = l - l2;
            }
        }
        long l3 = l - l2 + 1L;
        long l4 = 1L;
        f = 1.0f;
        long l5 = l2;
        while (l5-- > 0L) {
            f *= (float)l3++ / (float)l4++;
        }
        return f;
    }

    public static long ceil(float f) {
        return Math.round(Math.ceil(f));
    }

    public static float chbevl(float f, float[] fArray, int n) throws ArithmeticException {
        float f2;
        int n2 = 0;
        float f3 = fArray[n2++];
        float f4 = 0.0f;
        int n3 = n - 1;
        do {
            f2 = f4;
            f4 = f3;
            f3 = f * f4 - f2 + fArray[n2++];
        } while (--n3 > 0);
        return 0.5f * (f3 - f2);
    }

    private static long fac1(int n) {
        long l = n;
        if (n < 0) {
            l = Math.abs(n);
        }
        if (l > (long)longFactorials.length) {
            throw new IllegalArgumentException("Overflow");
        }
        long l2 = 1L;
        while (l > 1L) {
            l2 *= l--;
        }
        if (n < 0) {
            return -l2;
        }
        return l2;
    }

    private static float fac2(int n) {
        long l = n;
        if (n < 0) {
            l = Math.abs(n);
        }
        float f = 1.0f;
        while (l > 1L) {
            f *= (float)l--;
        }
        if (n < 0) {
            return -f;
        }
        return f;
    }

    public static float factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = longFactorials.length;
        if (n < n2) {
            return longFactorials[n];
        }
        int n3 = floatFactorials.length;
        if (n < n2 + n3) {
            return floatFactorials[n - n2];
        }
        return Float.POSITIVE_INFINITY;
    }

    public static long floor(float f) {
        return Math.round(Math.floor(f));
    }

    public static float log(float f, float f2) {
        return (float)(Math.log(f2) / Math.log(f));
    }

    public static float log10(float f) {
        return (float)(Math.log(f) * 0.43429448190325176);
    }

    public static float log2(float f) {
        return (float)(Math.log(f) * 1.4426950408889634);
    }

    public static float logFactorial(int n) {
        if (n >= 30) {
            float f = 1.0f / (float)n;
            float f2 = f * f;
            return (float)(((double)n + 0.5) * Math.log(n) - (double)n + 0.9189385175704956 + (double)(f * (0.083333336f + f2 * (-0.0027777778f + f2 * (7.936508E-4f + f2 * -5.952381E-4f)))));
        }
        return logFactorials[n];
    }

    public static long longFactorial(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative k");
        }
        if (n < longFactorials.length) {
            return longFactorials[n];
        }
        throw new IllegalArgumentException("Overflow");
    }

    public static float stirlingCorrection(int n) {
        if (n > 30) {
            float f = 1.0f / (float)n;
            float f2 = f * f;
            return f * (0.083333336f + f2 * (-0.0027777778f + f2 * (7.936508E-4f + f2 * -5.952381E-4f)));
        }
        return stirlingCorrection[n];
    }

    private static long xlongBinomial(long l, long l2) {
        return Math.round(FloatArithmetic.binomial(l, l2));
    }
}

