/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_norm;

public class SparseDoubleAlgebra {
    public static final SparseDoubleAlgebra DEFAULT = new SparseDoubleAlgebra();
    public static final SparseDoubleAlgebra ZERO;
    protected DoubleProperty property;

    private static double normInfinityRC(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D) {
        double d = 0.0;
        int n = sparseRCDoubleMatrix2D.rows();
        int[] nArray = sparseRCDoubleMatrix2D.getRowPointers();
        double[] dArray = sparseRCDoubleMatrix2D.getValues();
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                d2 += Math.abs(dArray[j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public SparseDoubleAlgebra() {
        this(DoubleProperty.DEFAULT.tolerance());
    }

    public SparseDoubleAlgebra(double d) {
        this.setProperty(new DoubleProperty(d));
    }

    public SparseDoubleCholeskyDecomposition chol(DoubleMatrix2D doubleMatrix2D, int n) {
        return new SparseDoubleCholeskyDecomposition(doubleMatrix2D, n);
    }

    public Object clone() {
        return new SparseDoubleAlgebra(this.property.tolerance());
    }

    public double det(DoubleMatrix2D doubleMatrix2D) {
        return this.lu(doubleMatrix2D, 0).det();
    }

    public SparseDoubleLUDecomposition lu(DoubleMatrix2D doubleMatrix2D, int n) {
        return new SparseDoubleLUDecomposition(doubleMatrix2D, n, true);
    }

    public double norm1(DoubleMatrix2D doubleMatrix2D) {
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        double d = doubleMatrix2D instanceof SparseCCDoubleMatrix2D ? Dcs_norm.cs_norm((Dcs_common.Dcs)((Dcs_common.Dcs)doubleMatrix2D.elements())) : Dcs_norm.cs_norm((Dcs_common.Dcs)((SparseRCDoubleMatrix2D)doubleMatrix2D).getColumnCompressed().elements());
        return d;
    }

    public double normInfinity(DoubleMatrix2D doubleMatrix2D) {
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        double d = doubleMatrix2D instanceof SparseRCDoubleMatrix2D ? SparseDoubleAlgebra.normInfinityRC((SparseRCDoubleMatrix2D)doubleMatrix2D) : SparseDoubleAlgebra.normInfinityRC(((SparseCCDoubleMatrix2D)doubleMatrix2D).getRowCompressed());
        return d;
    }

    public DoubleProperty property() {
        return this.property;
    }

    public SparseDoubleQRDecomposition qr(DoubleMatrix2D doubleMatrix2D, int n) {
        return new SparseDoubleQRDecomposition(doubleMatrix2D, n);
    }

    public void setProperty(DoubleProperty doubleProperty) {
        if (this == DEFAULT && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = doubleProperty;
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(Math.max(doubleMatrix2D.rows(), doubleMatrix2D.columns()));
        denseDoubleMatrix1D.viewPart(0, (int)doubleMatrix1D.size()).assign(doubleMatrix1D);
        if (doubleMatrix2D.rows() == doubleMatrix2D.columns()) {
            this.lu(doubleMatrix2D, 0).solve(denseDoubleMatrix1D);
            return denseDoubleMatrix1D;
        }
        this.qr(doubleMatrix2D, 0).solve(denseDoubleMatrix1D);
        return denseDoubleMatrix1D.viewPart(0, doubleMatrix2D.columns()).copy();
    }

    static {
        SparseDoubleAlgebra.DEFAULT.property = DoubleProperty.DEFAULT;
        ZERO = new SparseDoubleAlgebra();
        SparseDoubleAlgebra.ZERO.property = DoubleProperty.ZERO;
    }
}

