/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBufferConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer
extends PersistentObject
implements ShortBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBufferConsumer target;
    protected short[] elements;
    protected ShortArrayList list;
    protected int capacity;
    protected int size;

    public ShortBuffer(ShortBufferConsumer shortBufferConsumer, int n) {
        this.target = shortBufferConsumer;
        this.capacity = n;
        this.elements = new short[n];
        this.list = new ShortArrayList(this.elements);
        this.size = 0;
    }

    public void add(short s) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = s;
    }

    public void addAllOf(ShortArrayList shortArrayList) {
        int n = shortArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(shortArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

