% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDRCData.R
\name{calculateDRCData}
\alias{calculateDRCData}
\title{calculateDRCData}
\usage{
calculateDRCData(idrc_set, cut_time = NULL)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}

\item{cut_time}{Desired cut time.  If NULL will use the cut_time in the IncucyteDRCSet object (if set)}
}
\value{
IncucyteDRCSet object
}
\description{
For a given cut time, calculate values from the growth curves in a IncucyteDRCSet object
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])
test_idrc_set <- fitGrowthCurvesIndividual(test_idrc_set)
plotIncucyteDRCSet(test_idrc_set, grouped=FALSE)
plotIncucyteDRCSet(test_idrc_set, grouped=TRUE)
test_idrc_set <- calculateDRCData(test_idrc_set, cut_time=100)
print(test_idrc_set)
test_idrc_set$drc_data
plotIncucyteDRCSet(test_idrc_set)

}

