% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportDRCDataToPRISM.R
\name{exportDRCDataToPRISM}
\alias{exportDRCDataToPRISM}
\title{exportDRCDataToPRISM}
\usage{
exportDRCDataToPRISM(idrc_set, include_control = FALSE,
  add_metadata = FALSE)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}

\item{include_control}{Whether to include control sample as zero conc control}

\item{add_metadata}{Whether or not to merge IncucyteDRCSet metadata into the output}
}
\value{
IncucyteDRCSet object
}
\description{
Exports data in PRISM format for an IncucyteDRCSet
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])
test_idrc_set <- fitGrowthCurvesIndividual(test_idrc_set)
test_idrc_set <- calculateDRCData(test_idrc_set, cut_time=100)
exportDRCDataToPRISM(test_idrc_set)
exportDRCDataToPRISM(test_idrc_set, include_control=TRUE)
exportDRCDataToPRISM(test_idrc_set, include_control=TRUE, add_metadata=TRUE)

}

