% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateMatched.R
\name{evaluateMatched}
\alias{evaluateMatched}
\title{Evaluate product overlap between periods}
\usage{
evaluateMatched(x, pvar, qvar, pervar, prodID, output = "chained")
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}

\item{output}{A character string specifying whether the matching should be
done assuming a chained index or a fixed base index. No index is actually computed,
but the matching needs to know which periods are being compared. Default is chained.}
}
\value{
A list of two matrices, one for expenditures and one for counts.
The first four columns present the base period information
base_index (the base time period), base (base period expenditure or count),
base_matched (the expenditure or count of the base period after matching),
base_share (share of total expenditure in the base period that remains after
matching). Columns 5-8 are defined analogously for the current period. The matched
numbers for the base period should be interpreted as the count or expenditure
that remains after removal of products that exist in the base period, but not
in the current period. That is, products that existed in the base period but no
longer exist in the current period are removed by the matching. If new products
exist in the current period that were not available in the base period, this
does not affect the matched base period expenditure or count. The appearance
of new products is captured in the current period matched expenditure and counts.
Therefore, a base period share that is less than 1 indicates that products have
disappeared, while a current period share less than 1 indicates that new products
have appeared.

The count matrix has two additional columns, "new" and "leaving". The new column
gives the number of products that exist in the current period but not the base period.
The leaving column gives the count of products that exist in the base period
but not the current period. Matching removes both of these types of products.
}
\description{
Evaluate the counts and expenditure for each period with and without
matching items across periods.
}
\examples{
# create CES_sigma_2 dataset removing the observation in time period 4
# on product 1
df <- CES_sigma_2[!(CES_sigma_2$time==4 & CES_sigma_2$prodID==1),]
# evaluate the overlap between periods for this dataset assuming
# a chained index
evaluateMatched(df, pvar="prices", qvar="quantities", pervar="time",
prodID = "prodID", output="chained")
}
