% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarity.R
\name{mixScaleDissimilarity}
\alias{mixScaleDissimilarity}
\title{Computes mix, scale and absolute dissimilarity measures}
\usage{
mixScaleDissimilarity(
  x,
  pvar,
  qvar,
  prodID,
  pervar,
  measure = "absolute",
  combine = "geomean"
)
}
\arguments{
\item{x}{A dataframe}

\item{pvar}{string identifying the price variable in x}

\item{qvar}{string identifying the quantity variable in x}

\item{prodID}{string identifying the product id variable in x}

\item{pervar}{string identifying the time period variable in x}

\item{measure}{choice of dissimilarity measure. Valid options
are mix, scale or absolute.}

\item{combine}{specifies how to combine the price and quantity vectors.
"stack" stacks the price and quantity vectors, "geomean" computes
separate dissimilarity measures for prices and quantities then takes
the geometric mean of these.}
}
\value{
A matrix where the first two columns are the possible combinations
of periods and the third column is the dissimilarity measure.
}
\description{
This is a function to compute the Fox, Hill and Diewert 2004
dissimilarity measures.
}
\examples{
# estimate the dissimilarity between periods in the CES_sigma_2 dataset
# using the absolute measure of dissimilarity and the geometric mean
# to combine price and quantity information.
mixScaleDissimilarity(CES_sigma_2, pvar = "prices", qvar = "quantities",
pervar = "time", prodID = "prodID", measure = "absolute",
combine = "geomean")
}
\references{
Fox, K.J., R.J. Hill and W.E. Diewert (2004),
"Identifying outliers in multi-output models", Journal of
Productivity Analysis, 22, 73-94, 2004.
}
