% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inflect.R
\name{Inflect}
\alias{Inflect}
\title{This function analyzes raw abundance data from a Thermal Proteome Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.}
\usage{
Inflect(directory, Temperature, Rsq, NumSD, NReps)
}
\arguments{
\item{directory}{the directory where the source data files to be analyzed are saved. This is also the location where the results will be saved.}

\item{Temperature}{the temperatures from the heat treatment procedure. An example entry Temperature<-c(25,35,39.3,50.1,55.2,60.7,74.9,90)}

\item{Rsq}{the cutoff to be used for the melt shift curve fit. An example entry would be 0.95}

\item{NumSD}{the standard deviation cutoff to be used for the calculated melt shifts. For example, if NumSD = 2, proteins with melt shifts greater than 2 standard deviations from the mean will be considered significant.}

\item{NReps}{the number of replicate experiments to be analyzed}
}
\value{
xlsx files with calculated melt shift for each protein in the experiment along with Upset plots that show the overlap in number of proteins stabilized and destabilized between each replicate
}
\description{
This function analyzes raw abundance data from a Thermal Proteome Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.
}
